$(document).ready(function () {
    let date = new Date();

    // Jumat, 13 September 2024
    let dt = date.getDate();
    let day = ["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jum`at", "Sabtu"];
    let month = ["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];
    let year = date.getFullYear();

    $(".date-timer").text(day[date.getDay()] + ", " + dt + " " + month[date.getMonth()] + " " + year);

})

function redirectToGame(game) {
    const host = window.location.host;
    const protocol = window.location.protocol;

    if (host.includes("localhost") || protocol === "file:") {
        window.location.href = `${game}.html`;
    } else {
        window.location.href = `${protocol}//${host}/${game}.html`;
    }
}